Option Explicit

#include ..\lib\framework_domotics.vbs
#include local-parameters.inc

Sub main
Dim astrBuffer
Dim tabLines
Dim tabValues
Dim astrDevices
Dim astrConfig
Dim atabDv
Dim astrNbDv
Dim i, l
Dim astrDevice
Dim astrparam1
Dim ligne, section, parametre, valeur

WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "Launching " & G_FOLDER_NAME & " script", G_LOG_FILE
If CheckDevices(G_FOLDER_NAME, G_FILE_INI, G_STATUS_EXIST) Then
	astrDevices 		= hs.GetINISetting("COMMON","DEVICES","", G_FILE_INI)
	astrConfig  		= hs.GetINISetting("COMMON","CONFIG","..\scripts\config\", G_FILE_INI)
	atabDv	 			= Split(astrDevices, G_SEP)
	astrNbDv 			= UBound(atabDv) 
	astrBuffer = loadfile("C:\Program Files\Cumulus\realtime.txt",False)
	
	'Rcupration des infos de la station mto LaCrosse
	If (astrBuffer <> "") Then 
        	tabLines = Split(astrbuffer,chr(13))
       		tabValues = split(tablines(ubound(tabLines)-1),chr(32))
  	End if

	'Correction des points en virgules
	i = 0
	While (i <= ubound(tabvalues))
	tabvalues(i) = replace(tabvalues(i), ".",",")
        i = i+1
    	Wend

	'Dtermination de la saison en cours en fonction de la date du jour
	if (DateDiff("d", date(), "20/03/" & year(date())) > 0) then tabValues(0) = "Hiver"
	if (DateDiff("d", date(), "20/03/" & year(date())) =< 0) then tabValues(0) = "Printemps"	
	if (DateDiff("d", date(), "21/06/" & year(date())) =< 0) then tabValues(0) = "Et"
	if (DateDiff("d", date(), "22/09/" & year(date())) =< 0) then tabValues(0) = "Automne"	
	if (DateDiff("d", date(), "21/12/" & year(date())) =< 0) then tabValues(0) = "Hiver"
	
	'Affectation des valeurs rcupres aux bons devices
	i = 0
	While (i <= CInt(astrNbDv))
		astrDevice 			= hs.GetINISetting("DEVICE", "HC", "", astrConfig & atabDv(i)) & _ 
							  hs.GetINISetting("DEVICE", "DC", "", astrConfig & atabDv(i))
		astrparam1			= hs.GetINISetting("DEVICE", "PARAM1", "", astrConfig & atabDv(i))	  
        If (astrparam1 = "PREVISION") Then
            setDevice astrDevice, tabValues(1), "", ""
        ElseIf (astrparam1 = "TENDANCE") Then
            setDevice astrDevice, tabValues(18), "", ""
        ElseIf (astrparam1 = "TEMPERATUREINTERIEURE") Then
            setDevice astrDevice, tabValues(22) & "C", "", tabValues(22)*100
	ElseIf (astrparam1 = "TEMPERATUREEXTERIEURE" and tabValues(2)<>"---") Then
            setDevice astrDevice, tabValues(2) & "C", "", tabValues(2)*100
        ElseIf (astrparam1 = "HUMIDITEINTERIEURE") Then
            setDevice astrDevice, tabValues(23) & "%", "", tabValues(23)*100
	ElseIf (astrparam1 = "HUMIDITEEXTERIEURE" and tabValues(6)<>"---") Then
            setDevice astrDevice, tabValues(3) & "%", "", tabValues(3)*100
        ElseIf (astrparam1 = "VITESSEVENT" and tabValues(5)<>"---") Then
            setDevice astrDevice, tabValues(5) & " km/h", "", tabValues(5)*100
        ElseIf (astrparam1 = "DIRECTIONVENT" and tabValues(11)<>"---") Then
            setDevice astrDevice, tabValues(11), "", ""
        ElseIf (astrparam1 = "PRECIPITATIONJOUR" and tabValues(9)<>"---") Then
            setDevice astrDevice, tabValues(9) & " mm", "", tabValues(9)*100
        ElseIf (astrparam1 = "PRESSION") Then
            setDevice astrDevice, tabValues(10) & " hpa", "", tabValues(10)*100
	ElseIf (astrparam1 = "PRECIPITATIONHEURE" and tabValues(47)<>"---") Then
            setDevice astrDevice, tabValues(47) & " mm", "", tabValues(47)*100
	ElseIf (astrparam1 = "TEMPERATURERESSENTIE" and tabValues(24)<>"---") Then
            setDevice astrDevice, tabValues(24) & "C", "", tabValues(24)*100
	ElseIf (astrparam1 = "POINTDEROSEE" and tabValues(4)<>"---") Then
            setDevice astrDevice, tabValues(4) & "C", "", tabValues(4)*100
	ElseIf (astrparam1 = "SAISON") Then
            setDevice astrDevice, tabValues(0), "", ""
        Else
            WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "PARAM1 is unknown for " & astrDevice, G_LOG_FILE	
        End if
        i = i+1
    Wend
	  
Else
    WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_SEV, "Expected Device is unknown !", G_LOG_FILE
End if
WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "End of the script", G_LOG_FILE
End sub
