Option Explicit

#include ..\lib\framework_domotics.vbs
#include local-parameters.inc

Sub main
Dim tabValues(11)
Dim astrDevices
Dim astrConfig
Dim atabDv
Dim astrNbDv
Dim i
Dim astrDevice
Dim astrPARAM1
Dim aobjConn
Dim aobjResults
Dim astrSQL


WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "Launching " & G_FOLDER_NAME & " script", G_LOG_FILE
If CheckDevices(G_FOLDER_NAME, G_FILE_INI, G_STATUS_EXIST) Then
	astrDevices 		= hs.GetINISetting("COMMON","DEVICES","", G_FILE_INI)
	astrConfig  		= hs.GetINISetting("COMMON","CONFIG","..\scripts\config\", G_FILE_INI)
	atabDv	 		= Split(astrDevices, G_SEP)
	astrNbDv 		= UBound(atabDv) 
	
	i = 0
	While (i <= CInt(astrNbDv))
		astrDevice = hs.GetINISetting("DEVICE", "HC", "", astrConfig & atabDv(i)) & _ 
						hs.GetINISetting("DEVICE", "DC", "", astrConfig & atabDv(i))
		astrPARAM1 = hs.GetINISetting("DEVICE", "PARAM1", "", astrConfig & atabDv(i))	  
        	If (astrPARAM1 = "PRESSION") Then
		    tabvalues(1) = hs.devicevalue(astrDevice)           
        	ElseIf (astrPARAM1 = "TEMPERATUREINTERIEURE") Then
        	    tabvalues(2) = hs.devicevalue(astrDevice)
        	ElseIf (astrPARAM1 = "SAISON") Then

        	ElseIf (astrPARAM1 = "PREVISION") Then

        	ElseIf (astrPARAM1 = "TENDANCE") Then

        	ElseIf (astrPARAM1 = "HUMIDITEINTERIEURE") Then
        	    tabvalues(3) = hs.devicevalue(astrDevice)
        	ElseIf (astrPARAM1 = "TEMPERATUREEXTERIEURE") Then
        	    tabvalues(4) = hs.devicevalue(astrDevice)
        	ElseIf (astrPARAM1 = "HUMIDITEEXTERIEURE") Then
        	    tabvalues(5) = hs.devicevalue(astrDevice)
	       	ElseIf (astrPARAM1 = "TEMPERATURERESSENTIE") Then
        	    tabvalues(6) = hs.devicevalue(astrDevice)
	       	ElseIf (astrPARAM1 = "POINTDEROSEE") Then
        	    tabvalues(7) = hs.devicevalue(astrDevice)
	       	ElseIf (astrPARAM1 = "VITESSEVENT") Then
        	    tabvalues(8) = hs.devicevalue(astrDevice)
	       	ElseIf (astrPARAM1 = "DIRECTIONVENT") Then
        	    tabvalues(9) = hs.devicevalue(astrDevice)
	       	ElseIf (astrPARAM1 = "PRECIPITATIONHEURE") Then
        	    tabvalues(10) = hs.devicevalue(astrDevice)
	       	ElseIf (astrPARAM1 = "PRECIPITATIONJOUR") Then
        	    tabvalues(11) = hs.devicevalue(astrDevice)
        	Else
        	    WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_CRI, "PARAM1 is unknown for " & astrDevice, G_LOG_FILE	
        	End if
        	i = i+1
       Wend

	Set aobjConn = CreateObject("ADODB.Connection")
	aobjConn.Open(G_CONNECTION_STRING)
	astrSQL = "insert into meteo_lacrosse (pression, temp_int, hum_int, temp_ext, hum_ext, windchill, dewpoint, vitesse_vent, direction_vent, pluie1h, pluie24h) values ('" & tabvalues(1) & "','" & tabvalues(2) & "','" & tabvalues(3) & "','" & tabvalues(4) & "','" & tabvalues(5) & "','" & tabvalues(6) & "','" & tabvalues(7) & "','" & tabvalues(8) & "','" & tabvalues(9) & "','" & tabvalues(10) & "','" & tabvalues(11) & "')"  
	Set aobjResults = aobjConn.Execute(astrSQL)
	aobjConn.Close
	Set aobjConn = Nothing
	  
Else
    WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_SEV, "Expected Device is unknown !", G_LOG_FILE
End if
WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "End of the script", G_LOG_FILE
End sub