Option Explicit
#include ..\lib\framework_domotics.vbs
#include local-parameters.inc
Sub main
Dim astrBuffer
Dim tabLines
Dim tabValues(14)
Dim astrDevices
Dim astrConfig
Dim atabDv
Dim astrNbDv
Dim i, l
Dim astrDevice
Dim astrparam1
Dim ligne, section, parametre, valeur, requete, result, jour, mois, annee, daterequete

jour = right(date,2)
annee = left(date,4)
mois = mid(date,6,2)
daterequete = annee & "-" & mois & "-" & jour

WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "Launching " & G_FOLDER_NAME & " script", G_LOG_FILE
If CheckDevices(G_FOLDER_NAME, G_FILE_INI, G_STATUS_EXIST) Then
	astrDevices 		= hs.GetINISetting("COMMON","DEVICES","", G_FILE_INI)
	astrConfig  		= hs.GetINISetting("COMMON","CONFIG","..\scripts\config\", G_FILE_INI)
	atabDv	 			= Split(astrDevices, G_SEP)
	astrNbDv 			= UBound(atabDv) 
	astrBuffer = loadfile("C:\HeavyWeather\currdat.lst",False)
	
	'Rcupration des infos de la station mto LaCrosse
	If (astrBuffer <> "") Then 
		tabLines = Split(astrbuffer,chr(13))
		l = 0
		While (l <= ubound(tabLines))
			If (Mid(tabLines(l),2,1) = "[") Then
				section = Mid(tabLines(l),3,Len(tabLines(l))-3)
			Else
			    If (Instr(tabLines(l),"=")) > 0 Then
					parametre = Mid(tabLines(l),2,Instr(tabLines(l),"=")-3)
					valeur = Replace(Mid(tabLines(l),Instr(tabLines(l),"=")+2),Chr(34),"")
					
					If (section = "weather_picture" And parametre = "number") Then
						If (valeur = 0) Then tabValues(1) = "Pluvieux"
						If (valeur = 1) Then tabValues(1) = "Nuageux"
						If (valeur = 2) Then tabValues(1) = "Ensoleill"
					End If
					If (section = "weather_tendency" And parametre = "number" ) Then
						If (valeur = 0) Then tabValues(2) = "Stable"
						If (valeur = 1) Then tabValues(2) = "Hausse"
						If (valeur = 2) Then tabValues(2) = "Baisse"
					End If
					If (section = "indoor_temperature"  And parametre = "deg_F"  ) Then tabValues(3) = valeur
					If (section = "outdoor_temperature" And parametre = "deg_F"  ) Then tabValues(4) = valeur
					If (section = "indoor_humidity"     And parametre = "percent") Then tabValues(5) = valeur
					If (section = "outdoor_humidity"    And parametre = "percent") Then tabValues(6) = valeur
					If (section = "wind_speed"          And parametre = "mph"    ) Then tabValues(7) = valeur
					If (section = "wind_direction"      And parametre = "deg"   ) Then tabValues(8) = valeur
					If (section = "rain_24h"            And parametre = "inch"     ) Then tabValues(9) = valeur
					If (section = "pressure_relative"   And parametre = "inHg"    ) Then tabValues(10)  = valeur
					If (section = "rain_1h"  	    	And parametre = "inch"     ) Then tabValues(11)  = valeur
					If (section = "windchill" 	    	And parametre = "deg_F"  ) Then tabValues(12)  = valeur
					If (section = "dewpoint" 	    	And parametre = "deg_F"  ) Then tabValues(13)  = valeur
				End If
			End If
		l = l+ 1
		Wend
	End if	     
	
	'Envoi des infos  Wunderground


requete = "http://weatherstation.wunderground.com/weatherstation/updateweatherstation.php?ID=ICENTREV2&PASSWORD=0611346045&dateutc=" & daterequete & "+1%3A32%3A35&winddir=" & tabValues(8) & "&windspeedmph=" & tabValues(7) & "&windgustmph=0&tempf=" & tabValues(4) & "&rainin=" & tabValues(11) & "&dailyrainin=" & tabValues(9) & "&baromin=" & tabValues(10) & "&dewptf=" & tabValues(13) & "&humidity=" & tabValues(6) & "&weather=&clouds=&softwaretype=Heavy%20WeatherStation&action=updateraw"

result = hs.URLAction(requete, "GET", "", "")
WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "Envoi des donnes a Wunderground:" & result, G_LOG_FILE
	  
Else
    WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_SEV, "Expected Device is unknown !", G_LOG_FILE
End if
WriteLog G_FOLDER_NAME, G_SCRIPT_EVT, G_TIV_INF, "End of the script", G_LOG_FILE
End sub
